import { createSlice } from "@reduxjs/toolkit";

const initialState = {};

export const variationSlice = createSlice({
    name: "itemVariation",
    initialState,
    reducers: {
        variation: (state, { payload }) => {
            state[payload?.key] = payload?.value;
        },
        resetVariation: (state) => {
            for (let item in state) {
                delete state[item];
            }
        },
    },
});

export const { variation, resetVariation } = variationSlice.actions;

export default variationSlice.reducer;
